/**********************************************************************************/
/* MyFirstDeviceDemoWindow.cpp												*/
/**********************************************************************************/

#include <Application.h>
#include <Window.h>
#include <Button.h>
#include <View.h>
#include <stdio.h>
#include <Alert.h>
#include "MyFirstDeviceAPI.h"
#include "MyFirstDeviceDemoWindow.h"


#define NUM_WRITE_ELEMENTS 13
int32 iaWrite[NUM_WRITE_ELEMENTS] = {0,1,2,3,4,5,6,5,4,3,2,1,0};
int32 iaRead[NUM_WRITE_ELEMENTS];

const char* sBttnWriteCaption = "Hit me to write!";
const char* sBttnWriteLabel = "M_BTTN_WRITE";
BRect brBttnWriteRect(20,20,130,40);

const char* sBttnReadCaption = "Hit me to read!";
const char* sBttnReadLabel = "M_BTTN_READ";
BRect brBttnReadRect(20,20 +30,130,40+30);

const char* sBttnClearCaption = "Hit me to clear!";
const char* sBttnClearLabel = "M_BTTN_CLEAR";
BRect brBttnClearRect(20,20 +60,130,40+60);

MyFirstDeviceDemoWindow::MyFirstDeviceDemoWindow(BRect frame)
	: BWindow(frame, "Hello", B_TITLED_WINDOW, B_WILL_DRAW)
{
	/*create a connection to the device driver*/
	DevCon = new MyFirstDeviceAPI();
	
	BttnWrite = new BButton(brBttnWriteRect,
							sBttnWriteLabel,
							sBttnWriteCaption,
							new BMessage(MSG_BTTN_WRITE));
	AddChild(BttnWrite);
	BttnRead = new BButton(brBttnReadRect,
							sBttnReadLabel,
							sBttnReadCaption,
							new BMessage(MSG_BTTN_READ));
	AddChild(BttnRead);
	BttnClear = new BButton(brBttnClearRect,
							sBttnClearLabel,
							sBttnClearCaption,
							new BMessage(MSG_BTTN_CLEAR));
	AddChild(BttnClear);
	Show();
}

MyFirstDeviceDemoWindow::~MyFirstDeviceDemoWindow()
{
	delete DevCon;	
}

bool
MyFirstDeviceDemoWindow::QuitRequested(void)
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
}

void	
MyFirstDeviceDemoWindow::MessageReceived(BMessage* message)
{	
	int32 NumElements = NUM_WRITE_ELEMENTS;
	int32 i;
	
	switch(message->what)
	{
		case MSG_BTTN_WRITE:
			DevCon->WriteRange(iaWrite, 1, &NumElements);
			break;
		case MSG_BTTN_READ:
			DevCon->ReadRange(iaRead, 1, &NumElements);
			for( i =0; i< NUM_WRITE_ELEMENTS; i++)
			{ 
				if(iaWrite[i] != iaRead[i])
				{
					i= -1;
					break;
				}
			}
			if(i<0)
				SetTitle("doh");
			else
				SetTitle("OK");
			break;
		case MSG_BTTN_CLEAR:
			DevCon->ClearAllRegs();
			break;
		default:
			BWindow::MessageReceived(message);
	}
}